CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "", "critical", "NonAdobePayload", "Microsoft_VC80_CRT_x86", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "", "critical", "NonAdobePayload", "Microsoft_VC80_MFC_x86", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "", "critical", "NonAdobePayload", "Microsoft_VC80_MFCLOC_x86", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F2A2C3A4-9791-421F-8A14-492ABC2AA3CE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{4172315A-D216-4F0E-890B-12F8C0492956}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{358E1898-FF96-4965-BCAD-D6E235324CA3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{8A5A5AA0-8C73-47E3-A709-A3EF73C2824E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F744C5CA-1E70-41B8-B4D8-D7BC47E72C81}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{8302D447-4427-4AB2-9FC2-EAC74493153E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{0052EA49-3E43-47DC-9515-294A5650E6B4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{91BC0960-C329-44D6-983C-C374ED8420C6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F606343F-4F7A-4223-8B3A-18798C311C18}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{C38D81F1-15B7-4AB2-8865-95E74DDE8033}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D7A81029-291D-4213-961E-01537136FCA8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5190E24F-79E7-4BA4-9649-65C0B0D1B27F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F6EB1E81-82C7-4FE5-94FF-60A01F61B09F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{196EEEAF-1333-4D9B-9122-418422062B43}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{94166413-A5A8-42D8-9DFD-5385FB797A4B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{EEE3957D-0090-4403-AE1A-56E187192F6F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{0CDB3A50-680A-4C87-8D20-569989E6B65A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{8E8A4597-80A2-4A35-8CB0-B390FB9D8EC2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{8A3FE8CC-313C-44BA-A496-D616E30F1D77}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{914371A6-3173-43DA-875A-8565DD9EC18F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{406C4EE9-8E39-4DBC-BAD8-CDB03364E6F6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{FDDBAB56-D9C8-4B60-A164-605BCDDD344E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{A47F2407-2BA1-4068-B547-12AD49F96D30}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{A01CF8C2-EE6C-4D8C-BEF2-45DEFE7BED69}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{52800402-6B15-4D19-BCAE-B33229B64F07}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{E4D25306-E4DE-441A-A120-CB63D8331C44}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{DBF31E22-9BAA-46FB-B518-53440BD7FB26}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{4D3AE71E-174B-4701-BE80-8DFB349812BA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{90C1EF16-7CBC-45C1-BEF7-D598992F446E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{436EB212-1986-4F50-8BB1-45D13625D6C4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{FBCD6D23-0833-40FF-971E-1B4D8D1A2893}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{DDD30BD2-583E-4428-AE12-67BE35239C85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D8944850-412F-4C06-A854-51476A419333}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{FE34ABB1-2018-40A6-964E-4249E0D0C5B2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{80EA06A6-C10B-4B23-B623-9BC25A7D2C41}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{00E755A9-EF75-4D24-BFC6-EB034A9BE91A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{824F8D9F-2A52-4F26-8159-271BE316E003}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{1D8A0ECA-A171-42CD-8B4B-904C6AB3331F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{C16E9199-52AA-4D9E-8EF3-04236F8E5C8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{9AC6799E-8275-4A38-8158-64CA7FA75FD3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{38670113-C178-4ED5-BC6F-C080BF844470}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F458E488-FF40-4D79-9014-8FA63867EFB9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{8B2D854B-022E-46DF-8ADF-90EE83231114}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{896D2091-9434-40CF-8B81-BB5DA1592BE7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{9290E99F-C750-416D-A4B5-DF70974BEA8E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{9B039FA8-CA3E-4EAB-8D10-F12EDD5A0132}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{0CEF39BA-EFEE-474B-B871-F05B2CEC8488}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{A06F54D3-9DAE-4994-B11E-F849C7EB467F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{19C36659-EF60-4DAE-99E7-CACDB2BA955A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{27FCF543-6C42-4D73-92CA-1236E8661BF7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{DE7BF286-252A-48AC-B905-CEA3F686A72E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{2E3486FB-4E38-43DF-9530-129F43B06B64}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{3BA2B095-E462-4FD5-B8F6-4A1A50F3E24D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{9224A0DB-4A56-4B8E-9EF3-034C9A7A1C19}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{3AD4B630-A446-43B3-924B-841473E31314}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{0DED2075-1C0A-4183-AEB8-B8ED51DA64F1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{7ADED831-4955-48D7-BC0C-D631B6C1AA8D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{E468FD18-3CD9-4715-9338-819EB3FB1D56}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{C649F6F3-0E22-4CB7-915B-89544055943A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{89032A45-C1F3-43F5-9015-C7369C201977}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{FEFBC52C-96A6-4C19-8577-6756CC486D01}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{993BB76A-5705-4D4C-B5A7-3023EDD30E80}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{04FEB9A4-1565-42CA-B68B-02E552924214}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{CF3B02E0-AEDC-4E66-BC25-0372DD9EED0A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5B26AC51-CA80-481C-AB3D-FB37B8919468}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{CED19C4D-95FF-47FD-86FA-B646FF5B4C72}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D60CD1EF-5018-46E3-A67C-F9E4B5C3C979}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{FABE0667-0258-497C-AF35-988D892DDD35}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D1D63BBE-2987-4045-A0CF-78C178DEA8C9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{946345FE-4EF6-406E-85FA-F7997CE68541}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{7DF760EB-36A5-4A1C-A2F5-256C33F34615}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{A8CD7D0E-EF7B-4007-8D01-87A94F781C24}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{2CA68F74-F266-443C-A271-C976659873AD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{C39F95F7-1F0F-40F4-8E1E-74123CF6C4AD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{3E41FDDD-7DD6-4BC6-BE37-089A4D3513DE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{E4884CB4-5750-4355-BAF0-701880A697B6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{92298D3A-4D3A-482D-A3AE-3F07E439D5A2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{9144F288-A1BE-4561-9DDC-94530047BB04}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{1749ABE6-53BA-4453-B6E2-72D3ABA96431}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{C685E77E-9020-40B4-9BCB-83680DC06B98}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{18919AA8-6A9E-453B-B52C-C72608D6B6B5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{8C45FDED-92DC-4453-9EFB-62D2813264B4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{96AA2FB3-0F4C-41E6-BECB-6846A68C5130}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5BE9267F-7443-48EF-B243-D03DF472591D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{19F8CD00-9964-438A-B335-C6A5572A7EFD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{9597BD86-42C4-45AF-94E7-FE7D7B76426C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{8CDA5E16-D56D-43F4-A659-73BB41E43BA3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{B6726E9E-5AF4-4CAB-B562-DD452A325D33}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{CE7E4731-3A4D-4D0E-9455-0FB0A0E9A556}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D2F74C77-6947-41BD-B649-36983E313DF6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{7778C9D1-7F79-4D8F-8CF0-2BC5BC424124}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{6C085600-2ABC-4ACF-9B9F-9A04DF6FA452}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{558B286A-A655-452A-B8E7-26FE480E1C47}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D411A2A2-52B4-4F75-84E5-DB1E4A638DCB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{C59B800F-1A18-420C-9583-2396F2AED606}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{B35B999E-615B-412A-81CA-903C87AACFA2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5FBBC081-9EF8-49C3-AA1C-74497B93C1A3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{02ED5B7E-6679-4710-849B-0DDFDA14DFC4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{3B222FBF-15A9-4CA9-BF81-45A58BFB8C9F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D93400A7-860D-4B5C-8620-0F4D0FAE34E3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{87DA0985-5EC4-41DC-A0E1-86AAB1475B7A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F0E0865D-DDB0-4C7D-8091-1AF3C06FB4FE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5AC9FC85-E210-4483-82BC-C48729817058}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{05889534-371F-4013-AB7E-357C096241DB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{B4BA28A9-3F44-44C4-9531-EA7C66FF219F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F1D54951-C775-4AAB-B000-1EAB38327020}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{52301D29-4168-4CA8-9AC4-5532423EDE04}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{7270046E-4673-4861-B078-9D9656D86896}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{EF2A0395-D2C6-4B84-95EB-E5786F551964}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{579E1B94-0D25-4EA8-8648-AAFAE2477AB4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{DF1137A0-DFEF-415F-967A-786562FE45E9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{680D1E57-1034-4E99-8F54-227984F009B3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{19F510F6-F346-4E25-B72F-33621D236FEA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{77A1CAC3-3089-4573-9E2E-7E94A88F185D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{1C165E2D-562D-4D2A-B55A-B6443F6A5E3A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{3F15737A-9CA3-4E3F-B670-3569CF9BE421}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{173198EC-8817-428F-9E72-CF39AB87439E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{261F1B92-660B-49A3-8257-6910DC7C26C7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{92497DA0-33A6-4966-AA6E-841A539AC322}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{ABF8F4EF-521C-4BC0-8434-9707E6F4CBAF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5236AC8A-477C-482D-921F-395502C1AB76}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{4EDE8C64-0CC6-491A-BFA5-3FC0FC26B4C5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5C166631-392F-45EA-A6C8-DC6FF0B1A364}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{B1F76C2C-9714-4860-9C15-6F7355B0A61F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{1206824A-5F00-4EB4-99FF-CFA10F74537B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{A055EC32-4C89-4F6A-A23D-CE94BC918781}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{E71ED7A7-6DB7-4F4A-98B8-C893AFD7AFDD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{EFF0C330-3CA0-4DE2-93DC-3969207D93EA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{50337EDB-3A4A-47D3-AADE-E2300108E90B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{8DEEC382-AD77-4324-98F6-0C9B84D5AB19}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D9139620-494B-46E5-A975-4E43FE609A47}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F8D42C29-4981-4F44-B4EF-35CAF763FB9D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{1AA6EBF0-0131-4622-8E6E-4B277D00407B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{1BD40C02-2AA0-41E5-AE53-C1A30613DB11}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{DE6DBDD5-B6A8-4EDA-B88D-93348CC75630}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{043B46D2-8716-4AB0-B288-228DAAB69BE9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{07FAB2A6-58C9-4DCD-8196-261A339BA1F1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F36DD78A-77BE-4523-9842-DA65B082CF9B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{E3FAEFC5-D458-4005-86B8-EF1E5FE0D737}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{AEBE4430-B357-4285-B4FB-6BB0008D209F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{DF4A7E7B-FF27-4F10-B241-B299A6906FFD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{AB80060B-DAE9-4137-AB55-BF9F32C5123E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{150CCEB2-7946-41B2-94A3-728F2293317F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{081F3A09-AFA2-4903-A45E-14FE9DE5D450}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D7687B49-070F-40FA-87F7-43C6008CB72F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{2E7D430C-9A89-40E6-8D8E-88B4FF275A0D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5A8BA1AA-1A69-4E6A-BC4E-81A414BAF699}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{213FB1CC-2353-4B45-AA4E-DD6123997BD8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{A7BF15BE-DAA5-43F3-AA22-B3C17AB50003}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{FC10C7E0-D530-4857-A8AA-0CBA6FA76E70}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{1F384E2C-B4AC-452E-8209-FD9A980D5679}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D8E955DC-4836-438B-A0D6-7E8F01329986}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{A6CC9700-E37C-4BFC-87FF-6C0062C61105}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{C6B7A7C3-FFBD-45FD-8748-FB482DDDC9A0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{CB89E521-E20C-400A-BD4B-AD3E5B10A9FD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{2F9B7D3B-32D2-4EA1-BB88-F712CD6CE0EE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{A6D64F26-57E7-4088-A737-28E99624871C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F31A3462-CA24-414F-9B37-A01E6D739052}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D6D25414-E15E-4EC2-B5E2-4EB30B0DF120}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{31C384BB-DE28-4727-8DD1-38873062840F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{C56EF9F4-469E-4E97-BA76-0FF219D5DBCF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{B6083598-09B4-4035-B023-C1E76216EF82}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{86874D99-69E5-452F-8F5B-923A9ECBB495}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{E14A9A67-6795-4C27-B3B5-8618CB25D805}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5CCBA763-DDDC-43E2-B78C-E13C3F561F52}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{DC9DD518-7C7E-4515-98A9-FB7634ECF270}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{00F49EDE-67CD-4445-A953-4C51E97E742F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{6CF797F6-5DC3-45B7-93C8-B1907E0566B1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5630E969-EFE6-4139-B761-E28F3B4B3D55}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{B42D293E-2B4A-416B-89B1-5E4747695C44}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{E378744C-FB36-4F0F-9CDA-6833672BF9DA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{2D8AA345-E8A8-4000-94D2-35F205C48FC7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{53B0C344-684D-4F64-B4B2-88653700F0BA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{0791994D-CF83-4CDC-A465-5E97FDD8661B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{039F0D18-8FFA-4D51-85E4-B71FE501F77D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{3C866DB9-D765-4E15-8595-BABF644F29C6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{27DED802-3AE3-486E-A173-D3131663975E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F24BC1F8-49E1-4513-9709-45DB21A28745}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{E75AB122-27C7-411F-A8E9-B340C849992C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{469A8987-09D1-41B6-AC7F-E398C352C1C0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{049A0F3B-7F5D-48DE-9B99-9AA6A17A92B4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{2993BB93-7A62-4F95-86C1-172C4FBD67DC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{3985D9D6-4618-4A4F-A3FE-21EC97D4984C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{50BA9035-61D3-4653-B05D-D9D9ECA3A438}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{3DF3FE2C-FA08-4B4C-A5F6-702967811ACD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{6F8221FC-D5EF-48B1-B770-F1405968C3E0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{62C81283-7F71-4347-9F7E-1671713728E1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{58FD68F5-90BD-41EB-9F49-83AB5249D6ED}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{96BFCF67-4D5B-4BBC-A3E5-A78C0D10157C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{D59A867B-B287-488A-8016-B6DDB81D3E6A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{DFD62ABE-9185-484F-AC54-EFD0C575D1F9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{9427020D-A8F4-4F8C-BFD8-028A06E8A107}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{4700F2FC-9839-4F69-893E-58B4F00F1EEA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{2AB4ABFF-A8C3-404B-96F1-49995424326F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{842B97D6-A94C-4646-9192-530023AFC0CE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F7BC73D3-9454-4FED-B70B-222E3E907E97}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{3292AF61-F4F7-49A6-B82C-E8C7700C76E4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5ED05F17-B53B-49EE-8DB1-0BCCD1D7F616}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{F02171C9-C720-464D-8AEF-DEE8C77ABFB9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{054D8EAE-221A-4728-B5EA-B61B81A2560E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{6F29CBCE-BF09-4E6E-9798-01E00E5600B4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{849101A0-32D3-4C0D-9F82-10E3194AB45D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{583F8214-3564-48D6-9066-3A6D6094055D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{B36B543D-5525-453C-B713-6305C2551256}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{7EDED24E-F848-471B-8D7D-FED7534FC2A0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{3617966E-1F73-4968-BCE4-65785AF1848E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{36E5CED7-65F9-41E7-BA5D-B5E30E4709FD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{4F121746-095A-4651-A232-BB70F39791C1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{98A57DD6-FEF8-4A3E-9FED-914ABB552C86}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5F3F83A6-E054-41C2-92E6-03F8DCB8B14E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{7283FE5C-6B85-44D5-9CA9-9ED99D442E6C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{13E6C128-1AF2-4417-932A-F55EBE231AF3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{E1CFAA4D-FAFD-4C16-8B04-D4E26500A38D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{7132418D-DD8B-4E85-9C4F-A31AC5F87112}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{81BE9D4F-5DFE-44DF-8CE6-D416F1FADEA6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{C31DC4E6-5307-4209-AA4A-BAF0CC6E280B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{269BFB54-04F6-45E8-854F-D5042E14085F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{C8887D27-5F12-4398-8725-5C578C4DB91D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{8203C51C-D5DE-415C-A440-CAD21476C0E3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{653A7C71-43A1-48A0-BBBC-FD878156AD2C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{4488EFBA-9C1F-429A-9CFD-2938BAEE2A50}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{032F6D2E-D7A2-4A79-9406-CC4B9103F9CC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{060CD7DC-D945-48B6-B745-4F814DD14FE5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{83AF0407-02E2-4114-96E0-07A130CBDACE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{ADF15967-465B-41AB-9A18-D1EED15AE094}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{98F613B7-3C57-4930-B7CE-280FFC28D78D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{CD29A60E-225C-4E2C-A899-C7202A7C9156}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{DBCCF51C-3CA8-4FFC-A2B4-347A2816E0DA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{FB8F1FC9-FABA-455C-BFE3-67D19F0C83F4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{541A7E4B-B986-4330-AC14-D7FFA2B426D4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{EA969CF7-CCE0-4C5A-BF23-C57CCDE6B835}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{FCB93716-B52C-4B1D-8E07-F7483288D7E6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{E662B83B-058E-40CD-8770-4D27776E3674}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{5939DAA5-2083-4395-B339-53EA85FB5001}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{6EF0E3DC-2651-41C5-ACEA-EA3C5E2DA16F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{65D563B0-C0B2-4C3E-8B41-7CB1227F53B4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{E716A8FB-1B06-43F2-8AFE-B002B00DC4C5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "{98ABAB54-1487-408A-BAA9-8095F41B64AC}", "conflict", "", "", "")
INSERT INTO Payloads VALUES	("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "DVA", "DynamiclinkSupport", "5.0", "normal")
INSERT INTO PayloadData VALUES("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "0" , "PayloadInfo", '<PayloadInfo version="3.0.116.0"><BuildInfo>
    <Property name="Created">2010-03-04 14:34:10.038000</Property>
    <Property name="TargetName">AdobeDynamiclinkSupport5All</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{A8798E04-96FF-4564-9157-0D4C89CB794C}</Property>
    <Property name="ProductName">Adobe Dynamiclink Support</Property>
    <Property name="ProductVersion">5.0</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="1" name="Default" folderName="">[AdobeCommon]</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
		<Family>DVA</Family>
		<ProductName>DynamiclinkSupport</ProductName>
	<ProductVersion>5.0</ProductVersion>
    </ProductInfo>
  </Satisfies><Dependencies>
    <ProductInfo type="critical">
      <Family>NonAdobePayload</Family>
      <ProductName>Microsoft_VC80_CRT_x86</ProductName>
    </ProductInfo>
    <ProductInfo type="critical">
      <Family>NonAdobePayload</Family>
      <ProductName>Microsoft_VC80_MFC_x86</ProductName>
    </ProductInfo>
    <ProductInfo type="critical">
      <Family>NonAdobePayload</Family>
      <ProductName>Microsoft_VC80_MFCLOC_x86</ProductName>
    </ProductInfo>
  </Dependencies><Upgrades>
    <AdobeCode>{F2A2C3A4-9791-421F-8A14-492ABC2AA3CE}</AdobeCode>
    <AdobeCode>{4172315A-D216-4F0E-890B-12F8C0492956}</AdobeCode>
    <AdobeCode>{358E1898-FF96-4965-BCAD-D6E235324CA3}</AdobeCode>
    <AdobeCode>{8A5A5AA0-8C73-47E3-A709-A3EF73C2824E}</AdobeCode>
    <AdobeCode>{F744C5CA-1E70-41B8-B4D8-D7BC47E72C81}</AdobeCode>
    <AdobeCode>{8302D447-4427-4AB2-9FC2-EAC74493153E}</AdobeCode>
    <AdobeCode>{0052EA49-3E43-47DC-9515-294A5650E6B4}</AdobeCode>
    <AdobeCode>{91BC0960-C329-44D6-983C-C374ED8420C6}</AdobeCode>
    <AdobeCode>{F606343F-4F7A-4223-8B3A-18798C311C18}</AdobeCode>
    <AdobeCode>{C38D81F1-15B7-4AB2-8865-95E74DDE8033}</AdobeCode>
    <AdobeCode>{D7A81029-291D-4213-961E-01537136FCA8}</AdobeCode>
    <AdobeCode>{5190E24F-79E7-4BA4-9649-65C0B0D1B27F}</AdobeCode>
    <AdobeCode>{F6EB1E81-82C7-4FE5-94FF-60A01F61B09F}</AdobeCode>
    <AdobeCode>{196EEEAF-1333-4D9B-9122-418422062B43}</AdobeCode>
    <AdobeCode>{94166413-A5A8-42D8-9DFD-5385FB797A4B}</AdobeCode>
    <AdobeCode>{EEE3957D-0090-4403-AE1A-56E187192F6F}</AdobeCode>
    <AdobeCode>{0CDB3A50-680A-4C87-8D20-569989E6B65A}</AdobeCode>
    <AdobeCode>{8E8A4597-80A2-4A35-8CB0-B390FB9D8EC2}</AdobeCode>
    <AdobeCode>{8A3FE8CC-313C-44BA-A496-D616E30F1D77}</AdobeCode>
    <AdobeCode>{914371A6-3173-43DA-875A-8565DD9EC18F}</AdobeCode>
    <AdobeCode>{406C4EE9-8E39-4DBC-BAD8-CDB03364E6F6}</AdobeCode>
    <AdobeCode>{FDDBAB56-D9C8-4B60-A164-605BCDDD344E}</AdobeCode>
    <AdobeCode>{A47F2407-2BA1-4068-B547-12AD49F96D30}</AdobeCode>
    <AdobeCode>{A01CF8C2-EE6C-4D8C-BEF2-45DEFE7BED69}</AdobeCode>
    <AdobeCode>{52800402-6B15-4D19-BCAE-B33229B64F07}</AdobeCode>
    <AdobeCode>{E4D25306-E4DE-441A-A120-CB63D8331C44}</AdobeCode>
    <AdobeCode>{DBF31E22-9BAA-46FB-B518-53440BD7FB26}</AdobeCode>
    <AdobeCode>{4D3AE71E-174B-4701-BE80-8DFB349812BA}</AdobeCode>
    <AdobeCode>{90C1EF16-7CBC-45C1-BEF7-D598992F446E}</AdobeCode>
    <AdobeCode>{436EB212-1986-4F50-8BB1-45D13625D6C4}</AdobeCode>
    <AdobeCode>{FBCD6D23-0833-40FF-971E-1B4D8D1A2893}</AdobeCode>
    <AdobeCode>{DDD30BD2-583E-4428-AE12-67BE35239C85}</AdobeCode>
    <AdobeCode>{D8944850-412F-4C06-A854-51476A419333}</AdobeCode>
    <AdobeCode>{FE34ABB1-2018-40A6-964E-4249E0D0C5B2}</AdobeCode>
    <AdobeCode>{80EA06A6-C10B-4B23-B623-9BC25A7D2C41}</AdobeCode>
    <AdobeCode>{00E755A9-EF75-4D24-BFC6-EB034A9BE91A}</AdobeCode>
    <AdobeCode>{824F8D9F-2A52-4F26-8159-271BE316E003}</AdobeCode>
    <AdobeCode>{1D8A0ECA-A171-42CD-8B4B-904C6AB3331F}</AdobeCode>
    <AdobeCode>{C16E9199-52AA-4D9E-8EF3-04236F8E5C8F}</AdobeCode>
    <AdobeCode>{9AC6799E-8275-4A38-8158-64CA7FA75FD3}</AdobeCode>
    <AdobeCode>{38670113-C178-4ED5-BC6F-C080BF844470}</AdobeCode>
    <AdobeCode>{F458E488-FF40-4D79-9014-8FA63867EFB9}</AdobeCode>
    <AdobeCode>{8B2D854B-022E-46DF-8ADF-90EE83231114}</AdobeCode>
    <AdobeCode>{896D2091-9434-40CF-8B81-BB5DA1592BE7}</AdobeCode>
    <AdobeCode>{9290E99F-C750-416D-A4B5-DF70974BEA8E}</AdobeCode>
    <AdobeCode>{9B039FA8-CA3E-4EAB-8D10-F12EDD5A0132}</AdobeCode>
    <AdobeCode>{0CEF39BA-EFEE-474B-B871-F05B2CEC8488}</AdobeCode>
    <AdobeCode>{A06F54D3-9DAE-4994-B11E-F849C7EB467F}</AdobeCode>
    <AdobeCode>{19C36659-EF60-4DAE-99E7-CACDB2BA955A}</AdobeCode>
    <AdobeCode>{27FCF543-6C42-4D73-92CA-1236E8661BF7}</AdobeCode>
    <AdobeCode>{DE7BF286-252A-48AC-B905-CEA3F686A72E}</AdobeCode>
    <AdobeCode>{2E3486FB-4E38-43DF-9530-129F43B06B64}</AdobeCode>
    <AdobeCode>{3BA2B095-E462-4FD5-B8F6-4A1A50F3E24D}</AdobeCode>
    <AdobeCode>{9224A0DB-4A56-4B8E-9EF3-034C9A7A1C19}</AdobeCode>
    <AdobeCode>{3AD4B630-A446-43B3-924B-841473E31314}</AdobeCode>
    <AdobeCode>{0DED2075-1C0A-4183-AEB8-B8ED51DA64F1}</AdobeCode>
    <AdobeCode>{7ADED831-4955-48D7-BC0C-D631B6C1AA8D}</AdobeCode>
    <AdobeCode>{E468FD18-3CD9-4715-9338-819EB3FB1D56}</AdobeCode>
    <AdobeCode>{C649F6F3-0E22-4CB7-915B-89544055943A}</AdobeCode>
    <AdobeCode>{89032A45-C1F3-43F5-9015-C7369C201977}</AdobeCode>
  </Upgrades><Conflicts>
    <AdobeCode>{FEFBC52C-96A6-4C19-8577-6756CC486D01}</AdobeCode>
    <AdobeCode>{993BB76A-5705-4D4C-B5A7-3023EDD30E80}</AdobeCode>
    <AdobeCode>{04FEB9A4-1565-42CA-B68B-02E552924214}</AdobeCode>
    <AdobeCode>{CF3B02E0-AEDC-4E66-BC25-0372DD9EED0A}</AdobeCode>
    <AdobeCode>{5B26AC51-CA80-481C-AB3D-FB37B8919468}</AdobeCode>
    <AdobeCode>{CED19C4D-95FF-47FD-86FA-B646FF5B4C72}</AdobeCode>
    <AdobeCode>{D60CD1EF-5018-46E3-A67C-F9E4B5C3C979}</AdobeCode>
    <AdobeCode>{FABE0667-0258-497C-AF35-988D892DDD35}</AdobeCode>
    <AdobeCode>{D1D63BBE-2987-4045-A0CF-78C178DEA8C9}</AdobeCode>
    <AdobeCode>{946345FE-4EF6-406E-85FA-F7997CE68541}</AdobeCode>
    <AdobeCode>{7DF760EB-36A5-4A1C-A2F5-256C33F34615}</AdobeCode>
    <AdobeCode>{A8CD7D0E-EF7B-4007-8D01-87A94F781C24}</AdobeCode>
    <AdobeCode>{2CA68F74-F266-443C-A271-C976659873AD}</AdobeCode>
    <AdobeCode>{C39F95F7-1F0F-40F4-8E1E-74123CF6C4AD}</AdobeCode>
    <AdobeCode>{3E41FDDD-7DD6-4BC6-BE37-089A4D3513DE}</AdobeCode>
    <AdobeCode>{E4884CB4-5750-4355-BAF0-701880A697B6}</AdobeCode>
    <AdobeCode>{92298D3A-4D3A-482D-A3AE-3F07E439D5A2}</AdobeCode>
    <AdobeCode>{9144F288-A1BE-4561-9DDC-94530047BB04}</AdobeCode>
    <AdobeCode>{1749ABE6-53BA-4453-B6E2-72D3ABA96431}</AdobeCode>
    <AdobeCode>{C685E77E-9020-40B4-9BCB-83680DC06B98}</AdobeCode>
    <AdobeCode>{18919AA8-6A9E-453B-B52C-C72608D6B6B5}</AdobeCode>
    <AdobeCode>{8C45FDED-92DC-4453-9EFB-62D2813264B4}</AdobeCode>
    <AdobeCode>{96AA2FB3-0F4C-41E6-BECB-6846A68C5130}</AdobeCode>
    <AdobeCode>{5BE9267F-7443-48EF-B243-D03DF472591D}</AdobeCode>
    <AdobeCode>{19F8CD00-9964-438A-B335-C6A5572A7EFD}</AdobeCode>
    <AdobeCode>{9597BD86-42C4-45AF-94E7-FE7D7B76426C}</AdobeCode>
    <AdobeCode>{8CDA5E16-D56D-43F4-A659-73BB41E43BA3}</AdobeCode>
    <AdobeCode>{B6726E9E-5AF4-4CAB-B562-DD452A325D33}</AdobeCode>
    <AdobeCode>{CE7E4731-3A4D-4D0E-9455-0FB0A0E9A556}</AdobeCode>
    <AdobeCode>{D2F74C77-6947-41BD-B649-36983E313DF6}</AdobeCode>
    <AdobeCode>{7778C9D1-7F79-4D8F-8CF0-2BC5BC424124}</AdobeCode>
    <AdobeCode>{6C085600-2ABC-4ACF-9B9F-9A04DF6FA452}</AdobeCode>
    <AdobeCode>{558B286A-A655-452A-B8E7-26FE480E1C47}</AdobeCode>
    <AdobeCode>{D411A2A2-52B4-4F75-84E5-DB1E4A638DCB}</AdobeCode>
    <AdobeCode>{C59B800F-1A18-420C-9583-2396F2AED606}</AdobeCode>
    <AdobeCode>{B35B999E-615B-412A-81CA-903C87AACFA2}</AdobeCode>
    <AdobeCode>{5FBBC081-9EF8-49C3-AA1C-74497B93C1A3}</AdobeCode>
    <AdobeCode>{02ED5B7E-6679-4710-849B-0DDFDA14DFC4}</AdobeCode>
    <AdobeCode>{3B222FBF-15A9-4CA9-BF81-45A58BFB8C9F}</AdobeCode>
    <AdobeCode>{D93400A7-860D-4B5C-8620-0F4D0FAE34E3}</AdobeCode>
    <AdobeCode>{87DA0985-5EC4-41DC-A0E1-86AAB1475B7A}</AdobeCode>
    <AdobeCode>{F0E0865D-DDB0-4C7D-8091-1AF3C06FB4FE}</AdobeCode>
    <AdobeCode>{5AC9FC85-E210-4483-82BC-C48729817058}</AdobeCode>
    <AdobeCode>{05889534-371F-4013-AB7E-357C096241DB}</AdobeCode>
    <AdobeCode>{B4BA28A9-3F44-44C4-9531-EA7C66FF219F}</AdobeCode>
    <AdobeCode>{F1D54951-C775-4AAB-B000-1EAB38327020}</AdobeCode>
    <AdobeCode>{52301D29-4168-4CA8-9AC4-5532423EDE04}</AdobeCode>
    <AdobeCode>{7270046E-4673-4861-B078-9D9656D86896}</AdobeCode>
    <AdobeCode>{EF2A0395-D2C6-4B84-95EB-E5786F551964}</AdobeCode>
    <AdobeCode>{579E1B94-0D25-4EA8-8648-AAFAE2477AB4}</AdobeCode>
    <AdobeCode>{DF1137A0-DFEF-415F-967A-786562FE45E9}</AdobeCode>
    <AdobeCode>{680D1E57-1034-4E99-8F54-227984F009B3}</AdobeCode>
    <AdobeCode>{19F510F6-F346-4E25-B72F-33621D236FEA}</AdobeCode>
    <AdobeCode>{77A1CAC3-3089-4573-9E2E-7E94A88F185D}</AdobeCode>
    <AdobeCode>{1C165E2D-562D-4D2A-B55A-B6443F6A5E3A}</AdobeCode>
    <AdobeCode>{3F15737A-9CA3-4E3F-B670-3569CF9BE421}</AdobeCode>
    <AdobeCode>{173198EC-8817-428F-9E72-CF39AB87439E}</AdobeCode>
    <AdobeCode>{261F1B92-660B-49A3-8257-6910DC7C26C7}</AdobeCode>
    <AdobeCode>{92497DA0-33A6-4966-AA6E-841A539AC322}</AdobeCode>
    <AdobeCode>{ABF8F4EF-521C-4BC0-8434-9707E6F4CBAF}</AdobeCode>
    <AdobeCode>{5236AC8A-477C-482D-921F-395502C1AB76}</AdobeCode>
    <AdobeCode>{4EDE8C64-0CC6-491A-BFA5-3FC0FC26B4C5}</AdobeCode>
    <AdobeCode>{5C166631-392F-45EA-A6C8-DC6FF0B1A364}</AdobeCode>
    <AdobeCode>{B1F76C2C-9714-4860-9C15-6F7355B0A61F}</AdobeCode>
    <AdobeCode>{1206824A-5F00-4EB4-99FF-CFA10F74537B}</AdobeCode>
    <AdobeCode>{A055EC32-4C89-4F6A-A23D-CE94BC918781}</AdobeCode>
    <AdobeCode>{E71ED7A7-6DB7-4F4A-98B8-C893AFD7AFDD}</AdobeCode>
    <AdobeCode>{EFF0C330-3CA0-4DE2-93DC-3969207D93EA}</AdobeCode>
    <AdobeCode>{50337EDB-3A4A-47D3-AADE-E2300108E90B}</AdobeCode>
    <AdobeCode>{8DEEC382-AD77-4324-98F6-0C9B84D5AB19}</AdobeCode>
    <AdobeCode>{D9139620-494B-46E5-A975-4E43FE609A47}</AdobeCode>
    <AdobeCode>{F8D42C29-4981-4F44-B4EF-35CAF763FB9D}</AdobeCode>
    <AdobeCode>{1AA6EBF0-0131-4622-8E6E-4B277D00407B}</AdobeCode>
    <AdobeCode>{1BD40C02-2AA0-41E5-AE53-C1A30613DB11}</AdobeCode>
    <AdobeCode>{DE6DBDD5-B6A8-4EDA-B88D-93348CC75630}</AdobeCode>
    <AdobeCode>{043B46D2-8716-4AB0-B288-228DAAB69BE9}</AdobeCode>
    <AdobeCode>{07FAB2A6-58C9-4DCD-8196-261A339BA1F1}</AdobeCode>
    <AdobeCode>{F36DD78A-77BE-4523-9842-DA65B082CF9B}</AdobeCode>
    <AdobeCode>{E3FAEFC5-D458-4005-86B8-EF1E5FE0D737}</AdobeCode>
    <AdobeCode>{AEBE4430-B357-4285-B4FB-6BB0008D209F}</AdobeCode>
    <AdobeCode>{DF4A7E7B-FF27-4F10-B241-B299A6906FFD}</AdobeCode>
    <AdobeCode>{AB80060B-DAE9-4137-AB55-BF9F32C5123E}</AdobeCode>
    <AdobeCode>{150CCEB2-7946-41B2-94A3-728F2293317F}</AdobeCode>
    <AdobeCode>{081F3A09-AFA2-4903-A45E-14FE9DE5D450}</AdobeCode>
    <AdobeCode>{D7687B49-070F-40FA-87F7-43C6008CB72F}</AdobeCode>
    <AdobeCode>{2E7D430C-9A89-40E6-8D8E-88B4FF275A0D}</AdobeCode>
    <AdobeCode>{5A8BA1AA-1A69-4E6A-BC4E-81A414BAF699}</AdobeCode>
    <AdobeCode>{213FB1CC-2353-4B45-AA4E-DD6123997BD8}</AdobeCode>
    <AdobeCode>{A7BF15BE-DAA5-43F3-AA22-B3C17AB50003}</AdobeCode>
    <AdobeCode>{FC10C7E0-D530-4857-A8AA-0CBA6FA76E70}</AdobeCode>
    <AdobeCode>{1F384E2C-B4AC-452E-8209-FD9A980D5679}</AdobeCode>
    <AdobeCode>{D8E955DC-4836-438B-A0D6-7E8F01329986}</AdobeCode>
    <AdobeCode>{A6CC9700-E37C-4BFC-87FF-6C0062C61105}</AdobeCode>
    <AdobeCode>{C6B7A7C3-FFBD-45FD-8748-FB482DDDC9A0}</AdobeCode>
    <AdobeCode>{CB89E521-E20C-400A-BD4B-AD3E5B10A9FD}</AdobeCode>
    <AdobeCode>{2F9B7D3B-32D2-4EA1-BB88-F712CD6CE0EE}</AdobeCode>
    <AdobeCode>{A6D64F26-57E7-4088-A737-28E99624871C}</AdobeCode>
    <AdobeCode>{F31A3462-CA24-414F-9B37-A01E6D739052}</AdobeCode>
    <AdobeCode>{D6D25414-E15E-4EC2-B5E2-4EB30B0DF120}</AdobeCode>
    <AdobeCode>{31C384BB-DE28-4727-8DD1-38873062840F}</AdobeCode>
    <AdobeCode>{C56EF9F4-469E-4E97-BA76-0FF219D5DBCF}</AdobeCode>
    <AdobeCode>{B6083598-09B4-4035-B023-C1E76216EF82}</AdobeCode>
    <AdobeCode>{86874D99-69E5-452F-8F5B-923A9ECBB495}</AdobeCode>
    <AdobeCode>{E14A9A67-6795-4C27-B3B5-8618CB25D805}</AdobeCode>
    <AdobeCode>{5CCBA763-DDDC-43E2-B78C-E13C3F561F52}</AdobeCode>
    <AdobeCode>{DC9DD518-7C7E-4515-98A9-FB7634ECF270}</AdobeCode>
    <AdobeCode>{00F49EDE-67CD-4445-A953-4C51E97E742F}</AdobeCode>
    <AdobeCode>{6CF797F6-5DC3-45B7-93C8-B1907E0566B1}</AdobeCode>
    <AdobeCode>{5630E969-EFE6-4139-B761-E28F3B4B3D55}</AdobeCode>
    <AdobeCode>{B42D293E-2B4A-416B-89B1-5E4747695C44}</AdobeCode>
    <AdobeCode>{E378744C-FB36-4F0F-9CDA-6833672BF9DA}</AdobeCode>
    <AdobeCode>{2D8AA345-E8A8-4000-94D2-35F205C48FC7}</AdobeCode>
    <AdobeCode>{53B0C344-684D-4F64-B4B2-88653700F0BA}</AdobeCode>
    <AdobeCode>{0791994D-CF83-4CDC-A465-5E97FDD8661B}</AdobeCode>
    <AdobeCode>{039F0D18-8FFA-4D51-85E4-B71FE501F77D}</AdobeCode>
    <AdobeCode>{3C866DB9-D765-4E15-8595-BABF644F29C6}</AdobeCode>
    <AdobeCode>{27DED802-3AE3-486E-A173-D3131663975E}</AdobeCode>
    <AdobeCode>{F24BC1F8-49E1-4513-9709-45DB21A28745}</AdobeCode>
    <AdobeCode>{E75AB122-27C7-411F-A8E9-B340C849992C}</AdobeCode>
    <AdobeCode>{469A8987-09D1-41B6-AC7F-E398C352C1C0}</AdobeCode>
    <AdobeCode>{049A0F3B-7F5D-48DE-9B99-9AA6A17A92B4}</AdobeCode>
    <AdobeCode>{2993BB93-7A62-4F95-86C1-172C4FBD67DC}</AdobeCode>
    <AdobeCode>{3985D9D6-4618-4A4F-A3FE-21EC97D4984C}</AdobeCode>
    <AdobeCode>{50BA9035-61D3-4653-B05D-D9D9ECA3A438}</AdobeCode>
    <AdobeCode>{3DF3FE2C-FA08-4B4C-A5F6-702967811ACD}</AdobeCode>
    <AdobeCode>{6F8221FC-D5EF-48B1-B770-F1405968C3E0}</AdobeCode>
    <AdobeCode>{62C81283-7F71-4347-9F7E-1671713728E1}</AdobeCode>
    <AdobeCode>{58FD68F5-90BD-41EB-9F49-83AB5249D6ED}</AdobeCode>
    <AdobeCode>{96BFCF67-4D5B-4BBC-A3E5-A78C0D10157C}</AdobeCode>
    <AdobeCode>{D59A867B-B287-488A-8016-B6DDB81D3E6A}</AdobeCode>
    <AdobeCode>{DFD62ABE-9185-484F-AC54-EFD0C575D1F9}</AdobeCode>
    <AdobeCode>{9427020D-A8F4-4F8C-BFD8-028A06E8A107}</AdobeCode>
    <AdobeCode>{4700F2FC-9839-4F69-893E-58B4F00F1EEA}</AdobeCode>
    <AdobeCode>{2AB4ABFF-A8C3-404B-96F1-49995424326F}</AdobeCode>
    <AdobeCode>{842B97D6-A94C-4646-9192-530023AFC0CE}</AdobeCode>
    <AdobeCode>{F7BC73D3-9454-4FED-B70B-222E3E907E97}</AdobeCode>
    <AdobeCode>{3292AF61-F4F7-49A6-B82C-E8C7700C76E4}</AdobeCode>
    <AdobeCode>{5ED05F17-B53B-49EE-8DB1-0BCCD1D7F616}</AdobeCode>
    <AdobeCode>{F02171C9-C720-464D-8AEF-DEE8C77ABFB9}</AdobeCode>
    <AdobeCode>{054D8EAE-221A-4728-B5EA-B61B81A2560E}</AdobeCode>
    <AdobeCode>{6F29CBCE-BF09-4E6E-9798-01E00E5600B4}</AdobeCode>
    <AdobeCode>{849101A0-32D3-4C0D-9F82-10E3194AB45D}</AdobeCode>
    <AdobeCode>{583F8214-3564-48D6-9066-3A6D6094055D}</AdobeCode>
    <AdobeCode>{B36B543D-5525-453C-B713-6305C2551256}</AdobeCode>
    <AdobeCode>{7EDED24E-F848-471B-8D7D-FED7534FC2A0}</AdobeCode>
    <AdobeCode>{3617966E-1F73-4968-BCE4-65785AF1848E}</AdobeCode>
    <AdobeCode>{36E5CED7-65F9-41E7-BA5D-B5E30E4709FD}</AdobeCode>
    <AdobeCode>{4F121746-095A-4651-A232-BB70F39791C1}</AdobeCode>
    <AdobeCode>{98A57DD6-FEF8-4A3E-9FED-914ABB552C86}</AdobeCode>
    <AdobeCode>{5F3F83A6-E054-41C2-92E6-03F8DCB8B14E}</AdobeCode>
    <AdobeCode>{7283FE5C-6B85-44D5-9CA9-9ED99D442E6C}</AdobeCode>
    <AdobeCode>{13E6C128-1AF2-4417-932A-F55EBE231AF3}</AdobeCode>
    <AdobeCode>{E1CFAA4D-FAFD-4C16-8B04-D4E26500A38D}</AdobeCode>
    <AdobeCode>{7132418D-DD8B-4E85-9C4F-A31AC5F87112}</AdobeCode>
    <AdobeCode>{81BE9D4F-5DFE-44DF-8CE6-D416F1FADEA6}</AdobeCode>
    <AdobeCode>{C31DC4E6-5307-4209-AA4A-BAF0CC6E280B}</AdobeCode>
    <AdobeCode>{269BFB54-04F6-45E8-854F-D5042E14085F}</AdobeCode>
    <AdobeCode>{C8887D27-5F12-4398-8725-5C578C4DB91D}</AdobeCode>
    <AdobeCode>{8203C51C-D5DE-415C-A440-CAD21476C0E3}</AdobeCode>
    <AdobeCode>{653A7C71-43A1-48A0-BBBC-FD878156AD2C}</AdobeCode>
    <AdobeCode>{4488EFBA-9C1F-429A-9CFD-2938BAEE2A50}</AdobeCode>
    <AdobeCode>{032F6D2E-D7A2-4A79-9406-CC4B9103F9CC}</AdobeCode>
    <AdobeCode>{060CD7DC-D945-48B6-B745-4F814DD14FE5}</AdobeCode>
    <AdobeCode>{83AF0407-02E2-4114-96E0-07A130CBDACE}</AdobeCode>
    <AdobeCode>{ADF15967-465B-41AB-9A18-D1EED15AE094}</AdobeCode>
    <AdobeCode>{98F613B7-3C57-4930-B7CE-280FFC28D78D}</AdobeCode>
    <AdobeCode>{CD29A60E-225C-4E2C-A899-C7202A7C9156}</AdobeCode>
    <AdobeCode>{DBCCF51C-3CA8-4FFC-A2B4-347A2816E0DA}</AdobeCode>
    <AdobeCode>{FB8F1FC9-FABA-455C-BFE3-67D19F0C83F4}</AdobeCode>
    <AdobeCode>{541A7E4B-B986-4330-AC14-D7FFA2B426D4}</AdobeCode>
    <AdobeCode>{EA969CF7-CCE0-4C5A-BF23-C57CCDE6B835}</AdobeCode>
    <AdobeCode>{FCB93716-B52C-4B1D-8E07-F7483288D7E6}</AdobeCode>
    <AdobeCode>{E662B83B-058E-40CD-8770-4D27776E3674}</AdobeCode>
    <AdobeCode>{5939DAA5-2083-4395-B339-53EA85FB5001}</AdobeCode>
    <AdobeCode>{6EF0E3DC-2651-41C5-ACEA-EA3C5E2DA16F}</AdobeCode>
    <AdobeCode>{65D563B0-C0B2-4C3E-8B41-7CB1227F53B4}</AdobeCode>
    <AdobeCode>{E716A8FB-1B06-43F2-8AFE-B002B00DC4C5}</AdobeCode>
    <AdobeCode>{98ABAB54-1487-408A-BAA9-8095F41B64AC}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeDynamiclinkSupport-5.0">
    <DisplayName>Adobe Dynamiclink Support</DisplayName>
  </Channel><InstallDestinationMetadata relocatableSize="0" sysDriveSize="3471988"><Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>3471988</TotalSize>
      <MaxPathComponent>/Keyfiles/dynamiclink/5.0\ConflictingProcesses</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="3471988"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	<Process processType="NonAdobe" blocking="1">^[Dd][Yy][Nn][Aa][Mm][Ii][Cc][Ll][Ii][Nn][Kk][Mm][Aa][Nn][Aa][Gg][Ee][Rr]\.[Ee][Xx][Ee]</Process>
    </Win32>
<OSX>
      <Process processType="NonAdobe" blocking="1">^[Dd][Yy][Nn][Aa][Mm][Ii][Cc][Ll][Ii][Nn][Kk][Mm][Aa][Nn][Aa][Gg][Ee][Rr]</Process>
    </OSX>
  </ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="sq_AL">5.0</Value>
      <Value lang="ar_AE">5.0</Value>
      <Value lang="be_BY">5.0</Value>
      <Value lang="bg_BG">5.0</Value>
      <Value lang="ca_ES">5.0</Value>
      <Value lang="zh_CN">5.0</Value>
      <Value lang="zh_TW">5.0</Value>
      <Value lang="hr_HR">5.0</Value>
      <Value lang="cs_CZ">5.0</Value>
      <Value lang="da_DK">5.0</Value>
      <Value lang="nl_NL">5.0</Value>
      <Value lang="en_XC">5.0</Value>
      <Value lang="en_XM">5.0</Value>
      <Value lang="en_GB">5.0</Value>
      <Value lang="en_US">5.0</Value>
      <Value lang="et_EE">5.0</Value>
      <Value lang="fi_FI">5.0</Value>
      <Value lang="fr_FR">5.0</Value>
      <Value lang="fr_XM">5.0</Value>
      <Value lang="de_DE">5.0</Value>
      <Value lang="el_GR">5.0</Value>
      <Value lang="he_IL">5.0</Value>
      <Value lang="hu_HU">5.0</Value>
      <Value lang="hi_IN">5.0</Value>
      <Value lang="is_IS">5.0</Value>
      <Value lang="it_IT">5.0</Value>
      <Value lang="ja_JP">5.0</Value>
      <Value lang="ko_KR">5.0</Value>
      <Value lang="lv_LV">5.0</Value>
      <Value lang="lt_LT">5.0</Value>
      <Value lang="mk_MK">5.0</Value>
      <Value lang="nn_NO">5.0</Value>
      <Value lang="no_NO">5.0</Value>
      <Value lang="nb_NO">5.0</Value>
      <Value lang="pl_PL">5.0</Value>
      <Value lang="pt_BR">5.0</Value>
      <Value lang="ro_RO">5.0</Value>
      <Value lang="ru_RU">5.0</Value>
      <Value lang="sh_YU">5.0</Value>
      <Value lang="sk_SK">5.0</Value>
      <Value lang="sl_SI">5.0</Value>
      <Value lang="es_QM">5.0</Value>
      <Value lang="es_ES">5.0</Value>
      <Value lang="sv_SE">5.0</Value>
      <Value lang="th_TH">5.0</Value>
      <Value lang="tr_TR">5.0</Value>
      <Value lang="uk_UA">5.0</Value>
      <Value lang="vi_VN">5.0</Value>
      <Value lang="fr_CA">5.0</Value>
      <Value lang="es_MX">5.0</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="sq_AL">Adobe Dynamiclink Support</Value>
      <Value lang="ar_AE">Adobe Dynamiclink Support</Value>
      <Value lang="be_BY">Adobe Dynamiclink Support</Value>
      <Value lang="bg_BG">Adobe Dynamiclink Support</Value>
      <Value lang="ca_ES">Adobe Dynamiclink Support</Value>
      <Value lang="zh_CN">Adobe Dynamiclink Support</Value>
      <Value lang="zh_TW">Adobe Dynamiclink Support</Value>
      <Value lang="hr_HR">Adobe Dynamiclink Support</Value>
      <Value lang="cs_CZ">Adobe Dynamiclink Support</Value>
      <Value lang="da_DK">Adobe Dynamiclink Support</Value>
      <Value lang="nl_NL">Adobe Dynamiclink Support</Value>
      <Value lang="en_XC">Adobe Dynamiclink Support</Value>
      <Value lang="en_XM">Adobe Dynamiclink Support</Value>
      <Value lang="en_GB">Adobe Dynamiclink Support</Value>
      <Value lang="en_US">Adobe Dynamiclink Support</Value>
      <Value lang="et_EE">Adobe Dynamiclink Support</Value>
      <Value lang="fi_FI">Adobe Dynamiclink Support</Value>
      <Value lang="fr_FR">Adobe Dynamiclink Support</Value>
      <Value lang="fr_XM">Adobe Dynamiclink Support</Value>
      <Value lang="de_DE">Adobe Dynamiclink Support</Value>
      <Value lang="el_GR">Adobe Dynamiclink Support</Value>
      <Value lang="he_IL">Adobe Dynamiclink Support</Value>
      <Value lang="hu_HU">Adobe Dynamiclink Support</Value>
      <Value lang="hi_IN">Adobe Dynamiclink Support</Value>
      <Value lang="is_IS">Adobe Dynamiclink Support</Value>
      <Value lang="it_IT">Adobe Dynamiclink Support</Value>
      <Value lang="ja_JP">Adobe Dynamiclink Support</Value>
      <Value lang="ko_KR">Adobe Dynamiclink Support</Value>
      <Value lang="lv_LV">Adobe Dynamiclink Support</Value>
      <Value lang="lt_LT">Adobe Dynamiclink Support</Value>
      <Value lang="mk_MK">Adobe Dynamiclink Support</Value>
      <Value lang="nn_NO">Adobe Dynamiclink Support</Value>
      <Value lang="no_NO">Adobe Dynamiclink Support</Value>
      <Value lang="nb_NO">Adobe Dynamiclink Support</Value>
      <Value lang="pl_PL">Adobe Dynamiclink Support</Value>
      <Value lang="pt_BR">Adobe Dynamiclink Support</Value>
      <Value lang="ro_RO">Adobe Dynamiclink Support</Value>
      <Value lang="ru_RU">Adobe Dynamiclink Support</Value>
      <Value lang="sh_YU">Adobe Dynamiclink Support</Value>
      <Value lang="sk_SK">Adobe Dynamiclink Support</Value>
      <Value lang="sl_SI">Adobe Dynamiclink Support</Value>
      <Value lang="es_QM">Adobe Dynamiclink Support</Value>
      <Value lang="es_ES">Adobe Dynamiclink Support</Value>
      <Value lang="sv_SE">Adobe Dynamiclink Support</Value>
      <Value lang="th_TH">Adobe Dynamiclink Support</Value>
      <Value lang="tr_TR">Adobe Dynamiclink Support</Value>
      <Value lang="uk_UA">Adobe Dynamiclink Support</Value>
      <Value lang="vi_VN">Adobe Dynamiclink Support</Value>
      <Value lang="fr_CA">Adobe Dynamiclink Support</Value>
      <Value lang="es_MX">Adobe Dynamiclink Support</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "0", "ChannelID", "AdobeDynamiclinkSupport-5.0")
INSERT INTO PayloadData VALUES("{A8798E04-96FF-4564-9157-0D4C89CB794C}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeDynamiclinkSupport-5.0">
    <DisplayName>Adobe Dynamiclink Support</DisplayName>
  </Channel>')
